# 土質データXML抽出プログラム
#
# 初版作成者・作成日：合同会社ＧＤウイング 2022/03/19
# 
# 出力結果は必ずチェックをお願いいたします

import os
import sys
import glob
import datetime
import tkinter.messagebox
import tkinter.filedialog
import openpyxl
import decimal
import chardet
import xml.etree.ElementTree as ET

# ファイル選択のパスを、プログラムと同じフォルダにセットする
currentdir = os.path.dirname(os.path.abspath(__file__))

# プログラム名
program_name = "GD土質データXML抽出"

#####################
### 1.初期設定部  ###
#####################

## 1-1 ファイル名付加情報
# ファイル名に日本語の試験名等（＝rootタグ）を付加する場合は1を入力
# 付加しない場合は1以外（例えば0など）を入力
# ファイル名に使えない文字が含まれるなど、保存時にエラーが出る場合は1以外を入力
add_ja_name = 1

## 1-2 Excelへの入力方法(文字 or 数値)
# XMLにおいて数値と判定されたテキストを、Excelにおいて数値として入力する場合は1を入力
# 文字列として入力する場合は1以外（例えば0など）を入力
XLSX_str_num = 1

## 1-3 キーワードでグルーピング設定
# グルーピングするキーワード（＝XMLノードのタグ名）をリストに列記する
# 数字はExcelの行に相当する
reset_line_2 = ['試験情報', 'コメント']
reset_line_3 = ['ボーリングコア写真情報', '供試体']
reset_line_4 = []

######################
### 2.フォルダ選択 ###
######################

# 関数定義 ファイルオープン
def OpenFile():
	# Tkの小さいウィンドウが出る場合は以下の２行を追加すると非表示になる
	dummy_root = tkinter.Tk()
	dummy_root.withdraw()

	# ファイル上書きの注意表示
	tkinter.messagebox.showinfo(program_name, \
		"出力ファイル(Excel)は、XMLファイルがあるフォルダに作成した日付時刻付きのフォルダに作成します\n\r" + \
		"既存の出力ファイル(Excel)は上書きされますのでご注意ください\n\r" + \
		"中止する場合は次のフォルダ選択画面にてキャンセルしてください\n\n\r" + \
		"なお、サブフォルダ内のファイルは処理を行いません")

	#ディレクトリ選択ダイアログ表示
	working_folder = tkinter.filedialog.askdirectory(initialdir = currentdir)
	# キャンセルボタンを選択した場合は、メッセージボックスを表示してプログラムを終了するファイルを選択した場合は、inputfileを返す
	if working_folder == "":
		tkinter.messagebox.showinfo(program_name, "フォルダは選択されませんでした\n\rプログラムを終了します")
		sys.exit(0)
	else:
		# カレントディレクトリ変更
		os.chdir(working_folder)

## 2-1.処理したいXMLファイルがあるフォルダを選択する ##
OpenFile()

## 2-2.フォルダ内のXMLファイルのリストを生成 ##
XML_files = glob.glob('*.XML')

##########################
### 3.XML → Excel 変換 ###
##########################

# 関数定義 ファイルオープン
def Output_XLSX(element, XLSX_row = 1, XLSX_column = 1 , level = 0):
	print(element.tag, element.text)	# コンソール出力チェック
	groupe_wid = 7	# １グループあたりの列数

	if element.tag in reset_line_2:
		XLSX_r_c = 2, XLSX_column + level + 1 + groupe_wid
	elif element.tag in reset_line_3:
		XLSX_r_c = 3, XLSX_column + level + 1 + groupe_wid
	elif element.tag in reset_line_4:
		XLSX_r_c = 4, XLSX_column + level + 1 + groupe_wid
	else:
		XLSX_r_c = XLSX_row, XLSX_column
	
	XLsheet.cell(row = XLSX_r_c[0], column = XLSX_r_c[1] + level).value = element.tag		# タグをExcelに出力
	
	if XLSX_str_num == 1:	# テキストを数値としてExcelに出力する場合は、テキストを数値に変換する
		try:
			output_text = decimal.Decimal(element.text)
		except:
			output_text = element.text
	else:
		output_text = element.text
	
	XLsheet.cell(row = XLSX_r_c[0], column = XLSX_r_c[1] + groupe_wid).value = output_text
	
	for sub in element:
		XLSX_r_c = Output_XLSX(sub, XLSX_r_c[0] + 1,  XLSX_r_c[1] , level = level + 1)

	return XLSX_r_c[0], XLSX_r_c[1]

## 3-1.XMLファイルからExcelデータに変換する ##
# ファイルごとに変換処理を行う

Output_folder = "OUTPUT_" + datetime.datetime.now().strftime('%Y-%m-%d_%Hh%Mm%Ss')
os.mkdir(Output_folder)

for XML_file in XML_files:
	msgwd_label_text = XML_file + 'を処理中'	# ウインドウに表示
	print('\n' + XML_file + 'を処理中')			# 標準コンソールに表示
	XLbook = openpyxl.Workbook()
	XLsheet = XLbook.active

	# ２バイト文字を含むXMLを読み込むために、一度テキストデータとして取り込んでからXMLデータに変換する
	with open(XML_file, "rb") as file:
		enc = chardet.detect(file.read())
	with open(XML_file, encoding = enc["encoding"]) as file:
		# ファイルの読み込み処理　エラーが発生した場合は中断
		try:
			root = ET.fromstring(file.read())
		except:
			tkinter.messagebox.showerror(program_name, "「" + XML_file + "」の処理中にエラーが発生しました\n\rプログラムを終了します")
			XLbook.close
			sys.exit(0)
	
	# Output_XLSX関数にXMLデータを渡し、Excelデータに変換する
	for sub in root.iter(root.tag):
		i = Output_XLSX(sub, level = 0)
		print(sub.tag, sub.text)	# 標準コンソールに表示
	
	if add_ja_name == 1:
		XLfilename = XML_file.split('.')[0] + '(' + root.tag.strip('データシート情報') + ')' + '.xlsx'
	else:
		XLfilename = XML_file.split('.')[0]  + '.xlsx'

	XLbook.save(Output_folder + "//" + XLfilename)
	XLbook.close

if XML_files == []:	# フォルダ内にXMLファイルが無い場合は、出力フォルダを削除してプログラムを終了する。
	tkinter.messagebox.showinfo(program_name, "フォルダ内にXMLファイルが存在しませんでした。プログラムを終了します。")
	os.rmdir(Output_folder)
else:
	tkinter.messagebox.showinfo(program_name, "下記のファイルから抽出しました\n\n\r" + "\n".join(XML_files))